/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.mixin.core;

import com.pedrorok.hypertube.config.ClientConfig;
import com.pedrorok.hypertube.core.camera.DetachedCameraController;
import com.pedrorok.hypertube.core.camera.DetachedPlayerDirController;
import com.pedrorok.hypertube.core.travel.TravelManager;
import com.pedrorok.hypertube.mixin.core.CameraAccessorMixin;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.client.ClientHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public class CameraMixin {
    @Shadow
    private boolean detached;
    @Shadow
    private Entity entity;
    @Shadow
    private float partialTickTime;
    @Unique
    private long createHypertube$lastTickTime = 0L;
    @Unique
    private static final long createHypertube$TICK_INTERVAL_NS = 16666666L;

    @Unique
    public void createHypertube$setDetachedExternal(boolean newDetached) {
        this.detached = newDetached;
    }

    @Inject(method={"setup"}, at={@At(value="HEAD")}, cancellable=true)
    private void createHypertube$onSetup(BlockGetter p_90576_, Entity renderViewEntity, boolean isFrontView, boolean flipped, float PartialTicks, CallbackInfo ci) {
        float f;
        long currentTime;
        boolean hasHypertubeData;
        Options options = Minecraft.getInstance().options;
        LocalPlayer player = Minecraft.getInstance().player;
        if (renderViewEntity != player) {
            return;
        }
        boolean bl = hasHypertubeData = !TravelManager.hasHyperTubeData(renderViewEntity);
        if (hasHypertubeData || options.getCameraType().isFirstPerson() && ((Boolean)ClientConfig.get().ALLOW_FPV_INSIDE_TUBE.get()).booleanValue()) {
            DetachedCameraController.get().setDetached(false);
            if (hasHypertubeData) {
                DetachedPlayerDirController.get().setDetached(false);
            }
            return;
        }
        if (!((Boolean)ClientConfig.get().ALLOW_FPV_INSIDE_TUBE.get()).booleanValue()) {
            options.setCameraType(CameraType.THIRD_PERSON_BACK);
        }
        Camera cameraObj = (Camera)this;
        CameraAccessorMixin camera = (CameraAccessorMixin)cameraObj;
        if (!DetachedCameraController.get().isDetached()) {
            DetachedCameraController.get().startCamera(renderViewEntity);
            DetachedCameraController.get().setDetached(true);
            this.createHypertube$setDetachedExternal(true);
        }
        if ((currentTime = System.nanoTime()) - this.createHypertube$lastTickTime >= 16666666L) {
            DetachedCameraController.get().tickCamera(renderViewEntity);
            this.createHypertube$lastTickTime = currentTime;
        }
        camera.createHypertube$callSetRotation(DetachedCameraController.get().getYaw() * (float)(flipped ? -1 : 1), DetachedCameraController.get().getPitch());
        camera.createHypertube$callSetPosition(Mth.lerp((double)PartialTicks, (double)renderViewEntity.xo, (double)renderViewEntity.getX()), Mth.lerp((double)PartialTicks, (double)renderViewEntity.yo, (double)renderViewEntity.getY()), Mth.lerp((double)PartialTicks, (double)renderViewEntity.zo, (double)renderViewEntity.getZ()));
        if (renderViewEntity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)renderViewEntity;
            f = livingentity.getScale();
        } else {
            f = 1.0f;
        }
        camera.createHypertube$callMove(-camera.createHypertube$callGetMaxZoom(ClientHooks.getDetachedCameraDistance((Camera)cameraObj, (boolean)flipped, (float)f, (float)4.0f) * f), 0.0f, 0.0f);
        ci.cancel();
    }
}

